/*!
 * 
 * 4DView Pro library 0.0.0
 * 
 * Copyright(c) 4D SAS.  All rights reserved.
 * 
 * 4D (the "Software") and the corresponding source code remain
 * the exclusive property of 4D and/or its licensors and are protected by national
 * and/or international legislations.
 * 
 * This file is part of the source code of the Software provided under the relevant
 * 4D License Agreement available on http://www.4D.com/license whose compliance
 * constitutes a prerequisite to any use of this file and more generally of the
 * Software and the corresponding source code.
 * 
 */

(function () {

    Utils.addCommand('get-sheet-count', function (params) {
        return { "result": Utils.spread.getSheetCount() };
    });

    Utils.addCommand('set-sheet-count', function (params) {
        Utils.spread.setSheetCount(params.count);
    });

    Utils.addCommand('get-sheet-index', function (params) {
        return { "result": Utils.spread.getSheetIndex(params.name) };
    });

    Utils.addCommand('add-sheet', function (params) {
        let index;

        if (params.index < 0)
            index = 0;
        else if (params.index > Utils.spread.getSheetCount())
            index = Utils.spread.getSheetCount();
        else
            index = params.index;

        Utils.spread.addSheet(index, new GC.Spread.Sheets.Worksheet(params.name));
    });

    Utils.addCommand('remove-sheet', function (params) {
        let index = normalizeSheetIndex(params.index);

        if (index != null)
            Utils.spread.removeSheet(index);
    });

    Utils.addCommand('get-current-sheet', function (params) {
        return { "result": Utils.spread.getActiveSheetIndex() };
    });

    Utils.addCommand('set-current-sheet', function (params) {
        let index = normalizeSheetIndex(params.index);

        if (index != null)
            Utils.spread.setActiveSheetIndex(index);
    });

    Utils.addCommand('set-start-sheet', function (params) {
        let index = normalizeSheetIndex(params.index);

        if (index != null)
            Utils.spread.setStartSheetIndex(index);
    });

    Utils.addCommand('get-sheet-name', function (params) {
        let sheet = getSheetByIndex(params.index);
        let name = '';

        if (sheet != null)
            name = sheet.name();

        return { "result": name };
    });

    Utils.addCommand('set-sheet-name', function (params) {
        let sheet = getSheetByIndex(params.index);

        if (sheet != null)
            sheet.name(params.name);
    });

    Utils.addCommand('get-sheet-row-count', function (params) {
        let sheet = getSheetByIndex(params.index);
        var result = 0;

        if (sheet != null)
            result = sheet.getRowCount();

        return { "result": result };
    });

    Utils.addCommand('get-sheet-column-count', function (params) {
        let sheet = getSheetByIndex(params.index);
        var result = 0;

        if (sheet != null)
            result = sheet.getColumnCount();

        return { "result": result };
    });

    Utils.addCommand('set-sheet-row-count', function (params) {
        let sheet = getSheetByIndex(params.index);

        if ((sheet != null) && (params.rowCount > 0))
            sheet.setRowCount(params.rowCount);
    });

    Utils.addCommand('set-sheet-column-count', function (params) {
        let sheet = getSheetByIndex(params.index);

        if ((sheet != null) && (params.columnCount > 0))
            sheet.setColumnCount(params.columnCount);
    });


    //-------- utils ------

    function normalizeSheetIndex(index) {
        let validIndex = null;
        let nbSheets = Utils.spread.getSheetCount();

        if (nbSheets > 0) {
            if (index < 0)
                validIndex = 0;
            else if (index >= nbSheets)
                validIndex = nbSheets - 1;
            else
                validIndex = index;
        }
        return validIndex;
    }

    function getSheetByIndex(index) {
        var sheet = null;

        if (index == -1)
            sheet = Utils.spread.getActiveSheet();
        else {
            index = normalizeSheetIndex(index);
            if (index != null)
                sheet = Utils.spread.getSheet(index);
        }

        return sheet;
    }
})();